$basePath = "C:\videos\TODO"
$outputBase = "C:\videos\30M"
$targetSize = 30 * 1024 * 1024
$videoExtensions = "*.mp4", "*.mov", "*.avi", "*.mkv"
$ffmpegPath = "C:\videos\ffmpeg\bin\ffmpeg.exe"
$ffprobePath = "C:\videos\ffmpeg\bin\ffprobe.exe"

function Compress-Video {
    param ([string]$inputPath, [string]$relativePath)

    $outputDir = Join-Path $outputBase (Split-Path $relativePath -Parent)
    if (!(Test-Path $outputDir)) { New-Item -Path $outputDir -ItemType Directory | Out-Null }

    $baseName = [System.IO.Path]::GetFileNameWithoutExtension($inputPath)
    $outputPath = Join-Path $outputDir "${baseName}_30M.mp4"
    $duration = & $ffprobePath -v error -show_entries format=duration -of default=noprint_wrappers=1:nokey=1 "`"$inputPath`""

    $attempt = 1; $maxAttempts = 5; $success = $false; $qualityFactor = 0.9
    while (-not $success -and $attempt -le $maxAttempts) {
        $bitrate = [math]::Floor(($targetSize * 8 * $qualityFactor) / [double]$duration / 1000)
        & $ffmpegPath -y -i "`"$inputPath`"" -vf "scale=1280:-2" -c:v libx264 -b:v "${bitrate}k" `
            -maxrate "${bitrate}k" -bufsize "${bitrate}k" -c:a aac -b:a 96k -ac 2 -movflags +faststart "`"$outputPath`"" 2>$null

        if (Test-Path $outputPath) {
            $realSize = (Get-Item $outputPath).Length
            if ($realSize -le $targetSize) { $success = $true }
            else { Remove-Item $outputPath -Force; $qualityFactor -= 0.15; $attempt++ }
        } else { break }
    }
}
foreach ($ext in $videoExtensions) {
    Get-ChildItem -Path $basePath -Recurse -Filter $ext | ForEach-Object {
        $relativePath = $_.FullName.Substring($basePath.Length).TrimStart("\")
        Compress-Video -inputPath $_.FullName -relativePath $relativePath
    }
}