#!/bin/bash
BASE_DIR="./videos"
EXTENSIONS=("mp4" "mov" "avi" "mkv")

convertir_video() {
    input="$1"
    dir=$(dirname "$input")
    base=$(basename "$input")
    nom="${base%.*}"
    output="${dir}/${nom}_30M.mp4"

    ffmpeg -i "$input" -vf "scale=1280:-2" -c:v libx264 -crf 28 -c:a aac -b:a 96k -movflags +faststart "$output"
}

for ext in "${EXTENSIONS[@]}"; do
    find "$BASE_DIR" -type f -iname "*.$ext" | while read -r file; do
        convertir_video "$file"
    done
done
